package com.usercentrics.sdk.extensions

internal fun arrayOfNotEmpty(vararg elements: String): Array<String> {
    return elements.filter { it.isNotEmpty() }.toTypedArray()
}

internal fun String?.emptyToNull(): String? {
    return if (this?.isEmpty() == true) {
        null
    } else {
        this
    }
}

internal fun <T> Iterable<T>.sortedAlphaBy(
    caseSensitive: Boolean = false,
    selector: (T) -> String
): List<T> {
    return if (caseSensitive) {
        this.sortedBy(selector)
    } else {
        this.sortedWith(compareBy(String.CASE_INSENSITIVE_ORDER, selector))
    }
}

internal fun <E> Collection<E>.isMultiple(): Boolean {
    return size > 1
}

