package com.usercentrics.sdk.log

import com.usercentrics.sdk.errors.UsercentricsError

interface UsercentricsLogger {
    fun debug(message: String, cause: Throwable? = null)
    fun warning(message: String, cause: Throwable? = null)
    fun error(message: String, cause: Throwable? = null)
    fun error(error: UsercentricsError) {
        error.exception.let {
            error(it.message, it)
        }
    }
}
