package com.usercentrics.sdk.mediation.sdk

import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.data.MediationGranularConsent

internal abstract class AdjustSDKInterface(
    open val logger: UsercentricsLogger
) {

    abstract fun addPartnerSharingSetting(partner: String, consent: Boolean): Boolean
    abstract fun addAdjustGeneralConsent(consent: Boolean): Boolean
    abstract fun signalGooglePartnerFlags(granularConsent: MediationGranularConsent): Boolean

    protected fun logException(ex: Exception) {
        logger.debug("Failed to apply consent to Adjust", ex)
    }

    protected fun booleanToString(value: Boolean): String {
        return if (value) {
            "1"
        } else {
            "0"
        }
    }
}
