package com.usercentrics.sdk.mediation.service

import com.usercentrics.sdk.UsercentricsContext
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.mediation.data.UsercentricsMediation
import com.usercentrics.sdk.mediation.sdk.*

internal class MediationServiceFactory(
    private val logger: UsercentricsLogger,
    private val context: UsercentricsContext?,
) {

    fun build(): MediationService {
        val firebaseAnalyticsMediationSDK = FirebaseAnalyticsMediationSDK(
            name = "Firebase",
            vendorId = UsercentricsMediation.GOOGLE_VENDOR_ID,
            logger = logger
        )

        val firebaseAdvertisingMediationSDK = FirebaseAdvertisingMediationSDK(
            name = "Firebase Advertising",
            logger = logger,
            vendorId = UsercentricsMediation.GOOGLE_VENDOR_ID,
        )

        return MediationService(
            sdks = mapOf(
                UsercentricsMediation.unityAdsTemplateId to UnityAdsMediationSDK("Unity Ads", logger, context),
                UsercentricsMediation.appLovinTemplateId to AppLovinMediationSDK("App Lovin", logger, context),
                UsercentricsMediation.ironSourceTemplateId to IronSourceMediationSDK("Iron Source", logger),
                UsercentricsMediation.firebaseTemplateId to firebaseAnalyticsMediationSDK,
                UsercentricsMediation.firebaseAdvertisingTemplateId to firebaseAdvertisingMediationSDK,
                UsercentricsMediation.crashlyticsTemplateId to CrashlyticsMediationSDK("Crashlytics", logger),
                UsercentricsMediation.chartboostTemplateId to ChartboostMediationSDK("Chartboost", logger, context),
                UsercentricsMediation.singularTemplateId to SingularMediationSDK("Singular", logger),
                UsercentricsMediation.appsFlyerTemplateId to AppsFlyerMediationSDK("AppsFlyer", logger),
                UsercentricsMediation.airbridgeTemplateId to AirBridgeMediationSDK("AirBridge", logger),

                ),
            granularSDKs = listOf(firebaseAnalyticsMediationSDK, firebaseAdvertisingMediationSDK),
            adjust = AdjustMediationImpl("Adjust", logger, AdjustSDK(logger))
        )
    }
}
