package com.usercentrics.sdk.models.common


internal enum class InitialView {
    FIRST_LAYER,
    NONE,
}

/** All the different UI variants  */
enum class UsercentricsVariant {
    /** Present Default UI. */
    DEFAULT,

    /** Present CCPA UI. */
    CCPA,

    /** Present TCF UI. */
    TCF;

    internal val isDefault: Boolean get() = this == DEFAULT
    internal val isTCF: Boolean get() = this == TCF
    internal val isCCPA: Boolean get() = this == CCPA
}

/** Enum which defines from where the network calls would be made */
enum class NetworkMode {
    /** Rest of the world. */
    WORLD,

    /** Europe. */
    EU
}
