package com.usercentrics.sdk.models.common

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * Intermediate class to serialize the data in a JSON String that the Browser SDK will
 * consume, e.g. in a WebView. This is the 'getUserSessionData' process.
 * @suppress
 * */
@Serializable
internal data class UserSessionData(
    val consents: List<UserSessionDataConsent>,
    val controllerId: String,
    val language: String,
    val tcf: UserSessionDataTCF?,
    val ccpa: UserSessionDataCCPA?
)

@Serializable
internal data class UserSessionDataConsent(
    val status: Boolean,
    val templateId: String,
    @SerialName("timestamp")
    val timestampInMillis: Long
)

@Serializable
internal data class UserSessionDataTCF(
    val tcString: String,
    val vendorsDisclosed: List<Int>,
    val acString: String
)

@Serializable
internal data class UserSessionDataCCPA(
    val ccpaString: String,
    @SerialName("timestamp")
    val timestampInMillis: Long
)
