package com.usercentrics.sdk.models.settings

data class PredefinedUIDecision(
    val serviceId: String,
    val values: Map<String, Boolean>,
) {
    companion object {
        const val CONSENT_ID = "consent"
        const val LEGITIMATE_INTEREST_ID = "legitimateInterest"

        @Suppress("unused")
        // FIXME: why is this in place? used in SwitchStateManager.swift
        const val DEFAULT_DECISION_ID = CONSENT_ID

        const val DEFAULT_CONSENT_VALUE = false
        const val DEFAULT_LEGITIMATE_INTEREST_VALUE = true
    }

    fun consent(): Boolean? {
        return values[CONSENT_ID]
    }

    fun legitimateInterest(): Boolean? {
        return values[LEGITIMATE_INTEREST_ID]
    }
}
