package com.usercentrics.sdk.models.settings

import com.usercentrics.sdk.PurposeProps
import com.usercentrics.sdk.SpecialFeatureProps
import com.usercentrics.sdk.StackProps
import com.usercentrics.sdk.VendorProps

internal class TCFHolder {
    val id: String
    val tcfId: Int
    val title: String
    val isPartOfASelectedStack: Boolean
    val consentValue: Boolean
    val legitimateInterestValue: Boolean
    val mainSwitchSettings: PredefinedUISwitchSettingsUI?
    val contentDescription: String
    val illustrations: List<String>
    val showConsentToggle: Boolean
    val showLegitimateInterestToggle: Boolean
    val dependantSwitchSettings: List<PredefinedUIDependantSwitchSettings>?
    val numberOfVendors: Int?

    constructor(purposeProps: PurposeProps, hasMainToggle: Boolean, hideLegitimateInterestToggles: Boolean) {
        val purpose = purposeProps.purpose

        id = ServicesIdStrategy.id(purpose)
        tcfId = purpose.id
        title = purpose.name

        isPartOfASelectedStack = purpose.isPartOfASelectedStack

        consentValue = purposeProps.checked
        legitimateInterestValue = purposeProps.legitimateInterestChecked

        showConsentToggle = purpose.showConsentToggle
        showLegitimateInterestToggle = purpose.showLegitimateInterestToggle && !hideLegitimateInterestToggles

        mainSwitchSettings = if (hasMainToggle && showConsentToggle) {
            PredefinedUISwitchSettingsUI(id = PredefinedUIDecision.CONSENT_ID, disabled = false, currentValue = consentValue)
        } else {
            null
        }

        contentDescription = purpose.purposeDescription
        illustrations = purpose.illustrations
        dependantSwitchSettings = null
        numberOfVendors = purpose.numberOfVendors
    }

    constructor(specialFeatureProps: SpecialFeatureProps, hasMainToggle: Boolean) {
        val specialFeature = specialFeatureProps.specialFeature

        id = ServicesIdStrategy.id(specialFeature)
        tcfId = specialFeature.id
        title = specialFeature.name

        isPartOfASelectedStack = specialFeature.isPartOfASelectedStack

        consentValue = specialFeatureProps.checked
        legitimateInterestValue = false

        mainSwitchSettings = if (hasMainToggle) {
            PredefinedUISwitchSettingsUI(id = PredefinedUIDecision.CONSENT_ID, disabled = false, currentValue = consentValue)
        } else {
            null
        }

        contentDescription = specialFeature.purposeDescription
        illustrations = specialFeature.illustrations

        showConsentToggle = false
        showLegitimateInterestToggle = false
        dependantSwitchSettings = null
        numberOfVendors = null
    }

    constructor(stackProps: StackProps, hasMainToggle: Boolean, dependantSwitchSettings: List<PredefinedUIDependantSwitchSettings>) {
        val stack = stackProps.stack

        id = ServicesIdStrategy.id(stack)
        tcfId = stack.id
        title = stack.name

        isPartOfASelectedStack = false

        consentValue = stackProps.checked
        legitimateInterestValue = false

        mainSwitchSettings = if (hasMainToggle) {
            PredefinedUISwitchSettingsUI(id = PredefinedUIDecision.CONSENT_ID, disabled = false, currentValue = consentValue)
        } else {
            null
        }

        this.dependantSwitchSettings = dependantSwitchSettings

        contentDescription = stack.description
        illustrations = emptyList()

        showConsentToggle = false
        showLegitimateInterestToggle = false
        numberOfVendors = null
    }

    constructor(vendorProps: VendorProps, hideLegitimateInterestToggles: Boolean) {
        val vendor = vendorProps.vendor

        id = ServicesIdStrategy.id(vendor)
        tcfId = vendor.id
        title = vendor.name

        isPartOfASelectedStack = false

        consentValue = vendorProps.checked
        legitimateInterestValue = vendorProps.legitimateInterestChecked

        mainSwitchSettings = null

        contentDescription = ""
        illustrations = emptyList()

        showConsentToggle = vendor.showConsentToggle
        showLegitimateInterestToggle = vendor.showLegitimateInterestToggle && !hideLegitimateInterestToggles
        dependantSwitchSettings = null
        numberOfVendors = null
    }
}
