package com.usercentrics.sdk.services.api

import com.usercentrics.sdk.domain.api.http.HttpRequests

internal interface BillingApi {
    fun report(settingsId: String)
}

internal class BillingApiImpl(
    private val restClient: HttpRequests,
    private val networkResolver: NetworkResolver,
    private val appID: String
) : BillingApi {

    override fun report(settingsId: String) {
        val url = createBillingUrl(settingsId)
        restClient.get(url, null, {}, {})
    }

    private fun createBillingUrl(settingsId: String): String {
        val baseUrl = networkResolver.billingBaseUrl()
        return "${baseUrl}?appId=${appID}&settingsId=${settingsId}"
    }
}
