package com.usercentrics.sdk.services.api

import com.usercentrics.sdk.BuildKonfig
import com.usercentrics.sdk.UsercentricsDomains
import com.usercentrics.sdk.models.common.NetworkMode

internal class MainNetworkResolver(
    private val networkMode: NetworkMode,
    private val domains: UsercentricsDomains
) : NetworkResolver {

    override fun aggregatorBaseUrl(): String {
        if (isSelfHostedEnabled()) {
            return domains.aggregatorCdnUrl
        }

        return when (networkMode) {
            NetworkMode.WORLD -> BuildKonfig.endpoint_aggregatorCdn
            NetworkMode.EU -> BuildKonfig.endpoint_aggregatorCdnEu
        }
    }

    override fun billingBaseUrl(): String {
        return when (networkMode) {
            NetworkMode.WORLD -> BuildKonfig.endpoint_billing
            NetworkMode.EU -> BuildKonfig.endpoint_billingEu
        }
    }

    override fun getConsentsBaseUrl(): String {
        if (isSelfHostedEnabled()) {
            return domains.getConsentsUrl
        }

        return when (networkMode) {
            NetworkMode.WORLD -> BuildKonfig.endpoint_getConsents
            NetworkMode.EU -> BuildKonfig.endpoint_getConsentsEu
        }
    }

    override fun saveConsentsBaseUrl(): String {
        if (isSelfHostedEnabled()) {
            return domains.saveConsentsUrl
        }

        return when (networkMode) {
            NetworkMode.WORLD -> BuildKonfig.endpoint_saveConsents
            NetworkMode.EU -> BuildKonfig.endpoint_saveConsentsEu
        }
    }

    override fun cdnBaseUrl(): String {
        if (isSelfHostedEnabled()) {
            return domains.cdnUrl
        }

        return when (networkMode) {
            NetworkMode.WORLD -> BuildKonfig.endpoint_cdn
            NetworkMode.EU -> BuildKonfig.endpoint_cdnEu
        }
    }

    override fun analyticsBaseUrl(): String {
        if (isSelfHostedEnabled()) {
            return domains.analyticsUrl
        }

        return when (networkMode) {
            NetworkMode.WORLD -> BuildKonfig.endpoint_analytics
            NetworkMode.EU -> BuildKonfig.endpoint_analyticsEu
        }
    }

    private fun isSelfHostedEnabled(): Boolean {
        return domains.isValid()
    }
}
