package com.usercentrics.sdk.services.deviceStorage

import com.usercentrics.ccpa.CCPAStorage

internal fun KeyValueStorage.toCcpaStorage(): CCPAStorage = CCPAStorageProxy(this)

private class CCPAStorageProxy(val storage: KeyValueStorage) : CCPAStorage {
    override fun deleteKey(key: String) = storage.deleteKey(key)
    override fun putValue(key: String, value: String) = storage.put(key, value)
    override fun getValue(key: String, defaultValue: String?): String? = storage.getString(key, defaultValue)
}
