package com.usercentrics.sdk.services.initialValues.variants

import com.usercentrics.sdk.models.settings.GDPROptions
import com.usercentrics.sdk.v2.settings.data.CCPASettings

internal data class SharedInitialViewOptions(
    val versionChangeRequiresReshow: Boolean,
    val manualResurface: Boolean
)


internal data class GDPRInitialViewOptions(
    val gdprOptions: GDPROptions?,
    val isInEU: Boolean,
    val sharedInitialViewOptions: SharedInitialViewOptions
)

internal data class TCFInitialViewOptions(
    val resurfacePurposeChanged: Boolean,
    val resurfaceVendorAdded: Boolean,
    val noGDPRConsentActionPerformed: Boolean,
    val resurfacePeriodEnded: Boolean,
    val settingsTCFPolicyVersion: Int,
    val storedTcStringPolicyVersion: Int,
    val resurfaceATPChanged: Boolean,
    val sharedInitialViewOptions: SharedInitialViewOptions
)

internal data class CCPAInitialViewOptions(
    val ccpaOptions: CCPASettings?,
    val framework: String? = null,
    val sharedInitialViewOptions: SharedInitialViewOptions
)
