package com.usercentrics.sdk.services.initialValues.variants

internal object ShowCMPReasons {

    const val firstInitUSFramework = "SHOW_CMP cause: [##us_framework##] The 'Show CMP on first time visit' option is enabled and it is the first initialization"
    const val shouldReshowAfterTimeUSFramework = "SHOW_CMP cause: [##us_framework##] The 'Reshow ##us_framework## CMP' configured time has passed"
    const val versionChangeRequiresReshow = "SHOW_CMP cause: Settings version has changed"
    const val purposeChangedTCF = "SHOW_CMP cause: [TCF] The 'Resurface UI' option is enabled and selected vendors include undisclosed or changes in their declared Legal Basis"
    const val vendorAddedTCF = "SHOW_CMP cause: [TCF] The 'Resurface UI' option is enabled and a new vendor was added from the GVL"
    const val shouldReshowAfterTimeGDPR = "SHOW_CMP cause: [GDPR] The 'Reshow GDPR CMP' option is enabled and the configured time has passed"
    const val noConsentActionPerformedGDPR = "SHOW_CMP cause: [GDPR] This user has not yet provided consent"
    const val noGDPRConsentActionPerformed = "SHOW_CMP cause: [TCF] This user has not yet provided consent (not even on GDPR services)"
    const val periodEndedTCF = "SHOW_CMP cause: [TCF] The 'Resurface UI' option is enabled configured time has passed"
    const val resurfaceATPChanged = "SHOW_CMP cause: [TCF] The 'Resurface ATP list' option is enabled and Ad Technology Providers changed"
    const val manualResurface = "SHOW_CMP cause: The 'Manual Resurface option' on Admin Interface was triggered"
}

internal object AcceptAllImplicitlyReasons {

    const val firstInitializationUSFrameworks = "##us_framework## | Accept all implicitly cause: It is the first initialization"
    const val firstInitializationGDPR =
        "GDPR | Accept all implicitly cause: It is the first initialization, the 'Display CMP only to EU users' option is enabled and the user is not in EU"
    const val firstInitializationTCF = "TCF | Accept all non-IAB services implicitly cause: The 'Apply GDPR only to EU users' option is enabled and it is the first initialization"
}

internal fun formatUSFrameworkMessage(message: String, framework: String?): String {
    return message.replace("##us_framework##", framework ?: "CCPA")
}
