package com.usercentrics.sdk.services.settings

import com.usercentrics.sdk.core.settings.SettingsInitializationParameters
import com.usercentrics.sdk.models.settings.LegacyExtendedSettings

internal interface ISettingsLegacy {

    suspend fun initSettings(settingsInitParameters: SettingsInitializationParameters): Result<Unit>

    fun getSettings(): LegacyExtendedSettings
    fun setSettings(settings: LegacyExtendedSettings)

    fun setControllerId(controllerId: String)
    fun isCCPAEnabled(): Boolean
    fun getCCPAIABAgreementExists(): Boolean?
    fun isTCFEnabled(): Boolean

    fun isAdditionalConsentModeEnabled(): Boolean
    fun selectedAdTechProviders(): List<Int>

    fun clearConsents()
}
