package com.usercentrics.sdk.ui

import com.usercentrics.sdk.core.ClassLocator
import com.usercentrics.sdk.extensions.emptyToNull
import com.usercentrics.sdk.models.settings.PredefinedUIVariant
import com.usercentrics.sdk.predefinedUIFlagClassName
import com.usercentrics.sdk.predefinedUITVFlagClassName
import com.usercentrics.sdk.services.deviceStorage.KeyValueStorage
import com.usercentrics.sdk.services.deviceStorage.StorageKeys

internal class PredefinedUIMediatorImpl(
    private val classLocator: ClassLocator,
    private val keyValueStorage: KeyValueStorage,
) : PredefinedUIMediator {

    override fun isModulePresent(): Boolean {
        return classLocator.locate(predefinedUIFlagClassName) || classLocator.locate(predefinedUITVFlagClassName)
    }

    override fun storeVariant(variant: PredefinedUIVariant) {
        keyValueStorage.put(StorageKeys.UI_VARIANT.text, variant.name)
    }

    override fun popStoredVariant(): PredefinedUIVariant? {
        val variant = keyValueStorage.getString(StorageKeys.UI_VARIANT.text, null)?.emptyToNull() ?: return null

        keyValueStorage.deleteKey(StorageKeys.UI_VARIANT.text)

        return PredefinedUIVariant.valueOf(variant)
    }
}
