package com.usercentrics.sdk.ui.color

import kotlin.math.floor
import kotlin.math.min

object PredefinedUIColorMachine {

    private val white = Color(255, 255, 255)

    fun generateShadedColor(baseHexColor: String): UsercentricsShadedColor {
        val baseColor = Color.fromHex(baseHexColor)
        return UsercentricsShadedColor(
            color100 = baseColor.toHex(),
            color80 = shadedColorBy(baseColor, 0.80),
            color16 = shadedColorBy(baseColor, 0.16),
            color2 = shadedColorBy(baseColor, 0.02),
        )
    }

    fun lightenColor(baseHexColor: String, amount: Double): String {
        val baseColor = Color.fromHex(baseHexColor)

        val red = min(255.0, baseColor.red + (255 * amount))
        val green = min(255.0, baseColor.green + (255 * amount))
        val blue = min(255.0, baseColor.blue + (255 * amount))

        return Color(red.toInt(), green.toInt(), blue.toInt()).toHex()
    }

    private fun shadedColorBy(baseColor: Color, percentage: Double): String {
        val normalizedWeight = percentage * 2 - 1

        val weight1 = (normalizedWeight + 1) / 2.0
        val weight2 = 1 - weight1

        val red = floor(baseColor.red * weight1 + white.red * weight2)
        val blue = floor(baseColor.blue * weight1 + white.blue * weight2)
        val green = floor(baseColor.green * weight1 + white.green * weight2)

        return Color(red.toInt(), green.toInt(), blue.toInt()).toHex()
    }
}
