package com.usercentrics.sdk.ui.userAgent

import com.usercentrics.sdk.core.ClassLocator

internal const val FLUTTER_ANDROID_CLASS = "com.usercentrics.sdk.flutter.UCFlutterFlag"
internal const val FLUTTER_IOS_CLASS = "usercentrics_sdk.UCFlutterFlag"

internal const val REACT_NATIVE_ANDROID_CLASS = "com.usercentrics.reactnativeusercentrics.UCRNFlag"
internal const val REACT_NATIVE_IOS_CLASS = "react_native_usercentrics.UCRNFlag"

internal interface UserAgentSDKTypeEvaluator {

    fun eval(): String
}

internal class UserAgentSDKTypeEvaluatorImpl(
    private val classLocator: ClassLocator,
    private val sdkVersion: String,
) : UserAgentSDKTypeEvaluator {

    override fun eval(): String {
        return when {
            classLocator.locate(FLUTTER_ANDROID_CLASS) || classLocator.locate(FLUTTER_IOS_CLASS) -> "flutter"
            classLocator.locate(REACT_NATIVE_ANDROID_CLASS) || classLocator.locate(REACT_NATIVE_IOS_CLASS) -> "react-native"
            sdkVersionContainsUnityKeyword() -> "unity"
            else -> "native"
        }
    }

    private fun sdkVersionContainsUnityKeyword(): Boolean {
        return sdkVersion.contains("-unity")
    }
}
