package com.usercentrics.sdk.unity

import com.usercentrics.sdk.models.common.NetworkMode
import com.usercentrics.sdk.models.common.UsercentricsLoggerLevel
import com.usercentrics.sdk.models.common.UsercentricsVariant
import com.usercentrics.sdk.models.settings.UsercentricsConsentType
import com.usercentrics.sdk.ui.PredefinedUIInteraction
import com.usercentrics.sdk.v2.settings.data.ConsentDisclosureType
import com.usercentrics.sdk.v2.settings.data.PublishedAppPlatform
import com.usercentrics.tcf.core.model.RestrictionType
import kotlinx.serialization.KSerializer
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encodeToString
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import kotlinx.serialization.json.Json
import kotlinx.serialization.modules.SerializersModule

internal class UnityJsonParser {

    private val json = Json {
        serializersModule = SerializersModule {
            contextual(UsercentricsConsentType::class, unitySerializerEnum())
            contextual(PredefinedUIInteraction::class, unitySerializerEnum())
            contextual(UsercentricsLoggerLevel::class, unitySerializerEnum())
            contextual(RestrictionType::class, unitySerializerEnum())
            contextual(ConsentDisclosureType::class, unitySerializerEnum())
            contextual(NetworkMode::class, unitySerializerEnum())
            contextual(UsercentricsVariant::class, unitySerializerEnum())
            contextual(PublishedAppPlatform::class, unitySerializerEnum())
        }
    }

    inline fun <reified T> decodeFromString(str: String): T {
        return json.decodeFromString(str)
    }

    inline fun <reified T> encodeToString(input: T): String {
        return json.encodeToString(input)
    }

    private inline fun <reified T : Enum<T>> unitySerializerEnum(): KSerializer<T> {
        return object : KSerializer<T> {

            override val descriptor: SerialDescriptor = PrimitiveSerialDescriptor("${T::class.simpleName}", PrimitiveKind.INT)

            override fun deserialize(decoder: Decoder): T {
                return enumValues<T>()[decoder.decodeInt()]
            }

            override fun serialize(encoder: Encoder, value: T) {
                encoder.encodeInt(value.ordinal)
            }
        }
    }
}
