package com.usercentrics.sdk.unity.data

import com.usercentrics.sdk.GeolocationRuleset
import com.usercentrics.sdk.UsercentricsReadyStatus
import com.usercentrics.sdk.v2.location.data.UsercentricsLocation
import kotlinx.serialization.Serializable

@Serializable
internal data class UnityReadyStatus(
    val shouldCollectConsent: Boolean,
    val consents: List<UnityServiceConsent>,
    val location: UsercentricsLocation,
    val geolocationRuleset: GeolocationRuleset?,
) {
    constructor(readyStatus: UsercentricsReadyStatus, settingsId: String) : this(
        shouldCollectConsent = readyStatus.shouldCollectConsent,
        consents = readyStatus.consents.map { UnityServiceConsent(it) },
        location = readyStatus.location,
        geolocationRuleset = if (readyStatus.geolocationRuleset != null) {
            GeolocationRuleset(
                activeSettingsId = readyStatus.geolocationRuleset.activeSettingsId,
                bannerRequiredAtLocation = readyStatus.geolocationRuleset.bannerRequiredAtLocation
            )
        } else {
            GeolocationRuleset(
                activeSettingsId = settingsId,
                bannerRequiredAtLocation = true,
            )
        },
    )
}
