package com.usercentrics.sdk.unity.data

import com.usercentrics.sdk.UsercentricsConsentHistoryEntry
import com.usercentrics.sdk.UsercentricsServiceConsent
import kotlinx.serialization.Serializable

@Serializable
data class UnityServiceConsent(
    val templateId: String,
    val status: Boolean,
    val history: List<UsercentricsConsentHistoryEntry>,
    val dataProcessor: String,
    val version: String,
    val isEssential: Boolean,
    @Suppress("PropertyName") val _type: String,
    val category: String,
) {
    constructor(serviceConsent: UsercentricsServiceConsent) : this(
        templateId = serviceConsent.templateId,
        status = serviceConsent.status,
        history = serviceConsent.history,
        dataProcessor = serviceConsent.dataProcessor,
        version = serviceConsent.version,
        isEssential = serviceConsent.isEssential,
        _type = serviceConsent.type?.ordinal.toString(),
        category = serviceConsent.category
    )
}
