@file:Suppress("unused", "PropertyName")

package com.usercentrics.sdk.unity.data

import com.usercentrics.sdk.services.tcf.interfaces.*
import com.usercentrics.tcf.core.model.gvl.DataRetention
import com.usercentrics.tcf.core.model.gvl.RetentionPeriod
import com.usercentrics.tcf.core.model.gvl.VendorUrl
import kotlinx.serialization.Serializable

@Serializable
internal data class UnityTCFData(
    val features: List<TCFFeature>,
    val purposes: List<UnityTCFPurpose>,
    val specialFeatures: List<UnityTCFSpecialFeature>,
    val specialPurposes: List<TCFSpecialPurpose>,
    val stacks: List<TCFStack>,
    val vendors: List<UnityTCFVendor>,
    val tcString: String,
) {
    constructor(tcfData: TCFData) : this(
        features = tcfData.features,
        purposes = tcfData.purposes.map { UnityTCFPurpose(it) },
        specialFeatures = tcfData.specialFeatures.map { UnityTCFSpecialFeature(it) },
        specialPurposes = tcfData.specialPurposes,
        stacks = tcfData.stacks,
        vendors = tcfData.vendors.map { UnityTCFVendor(it) },
        tcString = tcfData.tcString,
    )
}

@Serializable
internal data class UnityTCFPurpose(
    val purposeDescription: String,
    val illustrations: List<String>,
    val id: Int,
    val name: String,
    val isPartOfASelectedStack: Boolean,
    val showConsentToggle: Boolean,
    val showLegitimateInterestToggle: Boolean,
    val _consent: String,
    val _legitimateInterestConsent: String,
    val _stackId: String,
) {
    constructor(purpose: TCFPurpose) : this(
        purposeDescription = purpose.purposeDescription,
        illustrations = purpose.illustrations,
        id = purpose.id,
        name = purpose.name,
        isPartOfASelectedStack = purpose.isPartOfASelectedStack,
        showConsentToggle = purpose.showConsentToggle,
        showLegitimateInterestToggle = purpose.showLegitimateInterestToggle,
        _consent = purpose.consent.toString(),
        _legitimateInterestConsent = purpose.legitimateInterestConsent.toString(),
        _stackId = purpose.stackId.toString(),
    )
}

@Serializable
internal data class UnityTCFSpecialFeature(
    val purposeDescription: String,
    val illustrations: List<String>,
    val id: Int,
    val name: String,
    val isPartOfASelectedStack: Boolean,
    val showConsentToggle: Boolean,
    val _consent: String,
    val _stackId: String,
) {
    constructor(specialFeature: TCFSpecialFeature) : this(
        purposeDescription = specialFeature.purposeDescription,
        illustrations = specialFeature.illustrations,
        id = specialFeature.id,
        name = specialFeature.name,
        isPartOfASelectedStack = specialFeature.isPartOfASelectedStack,
        showConsentToggle = specialFeature.showConsentToggle,
        _consent = specialFeature.consent.toString(),
        _stackId = specialFeature.stackId.toString(),
    )
}

@Serializable
internal data class UnityTCFVendor(
    val features: List<IdAndName>,
    val flexiblePurposes: List<IdAndName>,
    val id: Int,
    val legitimateInterestPurposes: List<IdAndName>,
    val name: String,
    val policyUrl: String,
    val purposes: List<IdAndName>,
    val restrictions: List<TCFVendorRestriction>,
    val specialFeatures: List<IdAndName>,
    val specialPurposes: List<IdAndName>,
    val showConsentToggle: Boolean,
    val showLegitimateInterestToggle: Boolean,
    val usesNonCookieAccess: Boolean,
    val deviceStorageDisclosureUrl: String? = null,
    val usesCookies: Boolean = false,
    val cookieRefresh: Boolean,
    val dataSharedOutsideEU: Boolean = false,
    val dataRetention: UnityDataRetention? = null,
    val dataCategories: List<IdAndName>,
    val vendorUrls: List<VendorUrl>,
    val _consent: String,
    val _legitimateInterestConsent: String,
    val _cookieMaxAgeSeconds: String,
) {
    constructor(vendor: TCFVendor) : this(
        features = vendor.features,
        flexiblePurposes = vendor.flexiblePurposes,
        id = vendor.id,
        legitimateInterestPurposes = vendor.legitimateInterestPurposes,
        name = vendor.name,
        policyUrl = vendor.policyUrl,
        purposes = vendor.purposes,
        restrictions = vendor.restrictions,
        specialFeatures = vendor.specialFeatures,
        specialPurposes = vendor.specialPurposes,
        showConsentToggle = vendor.showConsentToggle,
        showLegitimateInterestToggle = vendor.showLegitimateInterestToggle,
        usesNonCookieAccess = vendor.usesNonCookieAccess,
        deviceStorageDisclosureUrl = vendor.deviceStorageDisclosureUrl,
        usesCookies = vendor.usesCookies,
        cookieRefresh = vendor.cookieRefresh ?: false,
        dataSharedOutsideEU = vendor.dataSharedOutsideEU ?: false,
        dataRetention = if (vendor.dataRetention == null) null else UnityDataRetention(vendor.dataRetention),
        dataCategories = vendor.dataCategories,
        vendorUrls = vendor.vendorUrls,
        _consent = vendor.consent.toString(),
        _legitimateInterestConsent = vendor.legitimateInterestConsent.toString(),
        _cookieMaxAgeSeconds = vendor.cookieMaxAgeSeconds.toString(),
    )
}

@Serializable
data class UnityDataRetention(
    val purposes: RetentionPeriod,
    val specialPurposes: RetentionPeriod,
    val _stdRetention: String? = null,
) {
    constructor(dataRetention: DataRetention) : this(
        purposes = dataRetention.purposes,
        specialPurposes = dataRetention.specialPurposes,
        _stdRetention = dataRetention.stdRetention.toString(),
    )
}

@Serializable
internal data class UnityTCFIntegerList(
    val list: List<Int> = listOf()
)
