package com.usercentrics.sdk.unity.data

import com.usercentrics.sdk.UpdatedConsentPayload
import kotlinx.serialization.Serializable

@Serializable
data class UnityUpdatedConsentPayload(
    val consents: List<UnityServiceConsent>,
    val controllerId: String,
    val tcString: String? = null,
    val uspString: String? = null,
    val acString: String? = null,
) {
    constructor(payload: UpdatedConsentPayload) : this(
        consents = payload.consents.map { UnityServiceConsent(it) },
        controllerId = payload.controllerId,
        tcString = payload.tcString,
        uspString = payload.uspString,
        acString = payload.acString,
    )
}
