package com.usercentrics.sdk.v2.analytics.api

import com.usercentrics.sdk.UsercentricsAnalyticsEventType
import com.usercentrics.sdk.domain.api.http.HttpRequests
import com.usercentrics.sdk.models.api.ApiConstants
import com.usercentrics.sdk.services.api.NetworkResolver

internal class AnalyticsApi(
    private val networkResolver: NetworkResolver,
    private val restClient: HttpRequests,
    private val appId: String
) : IAnalyticsApi {

    override fun report(eventType: UsercentricsAnalyticsEventType, settingsId: String, abTestingVariant: String?, cacheBuster: String) {
        val url = buildUrl(
            eventType = eventType,
            settingsId = settingsId,
            abTestingVariant = abTestingVariant,
            cacheBuster = cacheBuster,
        )
        restClient.postSync(url, "", null)
    }

    private fun buildUrl(eventType: UsercentricsAnalyticsEventType, settingsId: String, abTestingVariant: String?, cacheBuster: String): String {
        val baseUrl = networkResolver.analyticsBaseUrl()
        return "$baseUrl/uct?v=${ApiConstants.ANALYTICS_VERSION}" +
                "&sid=$settingsId" +
                "&t=${eventType.value}" +
                "&r=$appId" +
                "&abv=${abTestingVariant ?: ""}" +
                "&cb=$cacheBuster"
    }
}

