package com.usercentrics.sdk.v2.analytics.facade

import com.usercentrics.sdk.UsercentricsAnalyticsEventType
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.v2.analytics.api.IAnalyticsApi
import com.usercentrics.sdk.v2.analytics.data.CacheBuster
import com.usercentrics.sdk.v2.async.dispatcher.Dispatcher
import com.usercentrics.sdk.v2.settings.service.ISettingsService

internal class AnalyticsFacade(
    private val analyticsApi: IAnalyticsApi,
    private val settingsService: ISettingsService,
    private val dispatcher: Dispatcher,
    private val logger: UsercentricsLogger,
) : IAnalyticsFacade {

    override fun report(eventType: UsercentricsAnalyticsEventType, settingsId: String, abTestingVariant: String?) {
        dispatcher.dispatch {
            val shouldReport = settingsService.settings!!.data.interactionAnalytics
            if (!shouldReport) {
                return@dispatch
            }

            analyticsApi.report(
                eventType = eventType,
                settingsId = settingsId,
                abTestingVariant = abTestingVariant,
                cacheBuster = CacheBuster.generate(),
            )
        }.onFailure {
            logger.error("Request failed", it)
        }
    }
}
