package com.usercentrics.sdk.v2.banner.service.mapper.ccpa

import com.usercentrics.sdk.models.gdpr.DefaultLabels
import com.usercentrics.sdk.models.settings.*
import com.usercentrics.sdk.v2.settings.data.UsercentricsCategory
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings
import com.usercentrics.sdk.v2.translation.data.LegalBasisLocalization

internal class CCPAViewSettingsMapper(
    private val settings: UsercentricsSettings,
    private val customization: PredefinedUICustomization,
    private val labels: DefaultLabels,
    private val controllerId: String,
    private val categories: List<UsercentricsCategory>,
    private val services: List<LegacyService>,
    private val optOutToggleInitialValue: Boolean,
    private val translations: LegalBasisLocalization
) {
    fun map(): PredefinedUIViewSettings {
        return PredefinedUIViewSettings(
            customization = customization,
            internationalizationLabels = labels(),
            firstLayerV2 = CCPAFirstLayerMapper(settings, customization, optOutToggleInitialValue).map(),
            secondLayerV2 = CCPASecondLayerMapper(settings, customization, controllerId, categories, services, optOutToggleInitialValue, translations).map()
        )
    }

    fun labels(): PredefinedUILabels {
        return PredefinedUILabels(
            general = labels.general,
            service = labels.service,
            firstLayerButtonLabels = FirstLayerButtonLabels(
                acceptAll = labels.general.acceptAll,
                denyAll = labels.general.denyAll,
                more = settings.ccpa!!.btnMoreInfo,
                save = settings.ccpa.btnSave,
            ),
            cookieInformationLabels = null,
            ariaLabels = labels.ariaLabels,
        )
    }
}
