package com.usercentrics.sdk.v2.banner.service.mapper.gdpr

import com.usercentrics.sdk.CategoryProps
import com.usercentrics.sdk.models.settings.*
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings
import com.usercentrics.sdk.v2.translation.data.LegalBasisLocalization

internal class GDPRSectionMapperTV(
    private val categoriesSectionLabel: String,
    private val servicesSectionLabel: String,
    private val consentLabel: String,
    private val hideTogglesForServices: Boolean,
    private val settings: UsercentricsSettings,
    private val serviceLabels: PredefinedUIServiceLabels,
    private val translations: LegalBasisLocalization,
) {

    fun map(categoriesEntries: List<CategoryProps>): PredefinedTVSecondLayerCardSection {
        return PredefinedTVSecondLayerCardSection(
            name = categoriesSectionLabel,
            entries = categoriesEntries
                .map { entry ->
                    val cardToggle = PredefinedUIToggleSettings(
                        id = ServicesIdStrategy.id(entry.category),
                        title = consentLabel,
                        consentId = PredefinedUIDecision.CONSENT_ID,
                        isEnabled = !entry.category.isEssential,
                        currentValue = entry.services.any { service -> service.consent.status },
                        dependentsIds = entry.services.map { ServicesIdStrategy.id(it) },
                        parentId = null
                    )
                    PredefinedTVSecondLayerCardEntry(
                        id = entry.category.categorySlug,
                        title = entry.category.label,
                        description = entry.category.description,
                        toggle = cardToggle,
                        content = tvCategoryContent(entry)
                    )
                }
        )
    }

    private fun tvCategoryContent(entry: CategoryProps): PredefinedTVSecondLayerSettingsContent {
        return PredefinedTVSecondLayerSettingsContent.Cards(listOf(
            PredefinedTVSecondLayerCardSection(
                name = servicesSectionLabel,
                entries = entry.services.map { service ->
                    val cardToggle = if (hideTogglesForServices) null else PredefinedUIToggleSettings(
                        id = ServicesIdStrategy.id(service),
                        title = consentLabel,
                        consentId = PredefinedUIDecision.CONSENT_ID,
                        isEnabled = !service.isEssential,
                        currentValue = service.consent.status,
                        parentId = ServicesIdStrategy.id(entry.category),
                        dependentsIds = listOf()
                    )
                    PredefinedTVSecondLayerCardEntry(
                        id = service.id,
                        title = service.name,
                        description = null,
                        toggle = cardToggle,
                        content = tvServiceContent(service)
                    )
                }
            )
        ))
    }

    private fun tvServiceContent(service: LegacyService): PredefinedTVSecondLayerSettingsContent {
        return PredefinedTVSecondLayerSettingsContent.DetailsWithVendors(
            title = translations.labels.details,
            extraToggle = null,
            entries = GDPRDetailsMapperTV(settings, serviceLabels).map(service),
        )
    }

}
