package com.usercentrics.sdk.v2.banner.service.mapper.gdpr

import com.usercentrics.sdk.models.gdpr.DefaultLabels
import com.usercentrics.sdk.models.settings.*
import com.usercentrics.sdk.v2.settings.data.UsercentricsCategory
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings
import com.usercentrics.sdk.v2.translation.data.LegalBasisLocalization

internal class GDPRViewSettingsMapper(
    private val settings: UsercentricsSettings,
    private val customization: PredefinedUICustomization,
    private val labels: DefaultLabels,
    private val translations: LegalBasisLocalization,
    controllerId: String,
    categories: List<UsercentricsCategory>,
    services: List<LegacyService>,
) {
    private val firstLayerMapper = GDPRFirstLayerMapper(settings, customization, labels)
    private val secondLayerMapper = GDPRSecondLayerMapper(
        settings = settings,
        customization = customization,
        controllerId = controllerId,
        categories = categories,
        services = services,
        serviceLabels = labels.service,
        translations = translations,
    )

    fun map(): PredefinedUIViewSettings {
        return PredefinedUIViewSettings(
            customization = customization,
            internationalizationLabels = labels(),
            firstLayerV2 = firstLayerMapper.map(),
            secondLayerV2 = secondLayerMapper.map(),
        )
    }

    fun mapTV(): PredefinedTVViewSettings {
        return PredefinedTVViewSettings(
            customization = customization,
            firstLayer = firstLayerMapper.mapTV(),
            secondLayer = secondLayerMapper.mapTV(),
            ariaLabels = labels.ariaLabels,
        )
    }

    fun labels(): PredefinedUILabels {
        return PredefinedUILabels(
            general = labels.general,
            service = labels.service,
            firstLayerButtonLabels = FirstLayerButtonLabels(
                acceptAll = labels.general.acceptAll,
                denyAll = labels.general.denyAll,
                more = labels.general.more,
                save = settings.labels.btnSave,
            ),
            cookieInformationLabels = null,
            ariaLabels = labels.ariaLabels,
        )
    }
}
