package com.usercentrics.sdk.v2.consent.data

import kotlinx.serialization.EncodeDefault
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable

@OptIn(ExperimentalSerializationApi::class)
@Serializable
internal data class SaveConsentsDto(
    val action: String,
    val appVersion: String,
    val controllerId: String,
    val language: String,
    val settingsId: String,
    val settingsVersion: String,
    val consentString: String,
    val consentMeta: String,
    val consents: List<ConsentStatusDto>,
    val bundleId: String,
    val sdkVersion: String,
    val userOS: String,
    val xdevice: Boolean,
    val analytics: Boolean,
    val acString: String,
    @EncodeDefault(EncodeDefault.Mode.NEVER)
    val webhook: Boolean = false,
)
