package com.usercentrics.sdk.v2.cookie.repository

import com.usercentrics.sdk.core.json.JsonParser
import com.usercentrics.sdk.v2.cookie.api.ICookieInformationApi
import com.usercentrics.sdk.v2.settings.data.ConsentDisclosureObject

internal class CookieInformationRepository(
    private val cookieInformationApi: ICookieInformationApi,
    private val json: JsonParser
) : ICookieInformationRepository {

    override fun fetchCookieInfo(cookieInfoURL: String): ConsentDisclosureObject {
        val response = cookieInformationApi.getCookiesInfo(cookieInfoURL)
        return json.decodeFromString(response.body)
    }
}
