package com.usercentrics.sdk.v2.cookie.service

import com.usercentrics.sdk.models.settings.PredefinedUICookieInformationLabels
import com.usercentrics.sdk.models.settings.PredefinedUIDeviceStorageContent
import com.usercentrics.sdk.services.settings.ISettingsLegacy
import com.usercentrics.sdk.v2.async.dispatcher.Dispatcher
import com.usercentrics.sdk.v2.banner.service.mapper.tcf.storageinfo.DeviceStorageMapper
import com.usercentrics.sdk.v2.cookie.repository.ICookieInformationRepository
import com.usercentrics.sdk.v2.tcf.service.ITCFService
import com.usercentrics.tcf.core.model.gvl.Purpose

internal class CookieInformationService(
    private val dispatcher: Dispatcher,
    private val tcfService: ITCFService,
    private val cookieInformationRepository: ICookieInformationRepository,
    private val settingsLegacy: ISettingsLegacy
) : UsercentricsCookieInformationService {

    override fun fetchCookieInfo(
        cookieInfoURL: String,
        onSuccess: (List<PredefinedUIDeviceStorageContent>) -> Unit,
        onError: () -> Unit
    ) {
        dispatcher.dispatch {
            val purposes = getVendorListOrTranslatedDeclarationsPurposes()

            val response = cookieInformationRepository.fetchCookieInfo(cookieInfoURL)
            DeviceStorageMapper(
                deviceStorage = response,
                cookieInformationLabels = cookieInformationLabels()!!,
                purposes = purposes ?: mapOf()
            ).map()
        }.onSuccess {
            dispatcher.dispatchMain { onSuccess(it) }
        }.onFailure {
            dispatcher.dispatchMain { onError() }
        }
    }

    private fun getVendorListOrTranslatedDeclarationsPurposes(): Map<String, Purpose>? {
        val vendorList = tcfService.vendorList!!
        val declarations = tcfService.declarations

        return if (declarations != null) {
            declarations.purposes
        } else {
            vendorList.purposes
        }
    }

    override fun cookieInformationLabels(): PredefinedUICookieInformationLabels? = settingsLegacy.getSettings().tcfui?.labels?.cookieInformation
}
