package com.usercentrics.sdk.v2.etag.cache

import com.usercentrics.sdk.v2.etag.repository.EtagHolder

interface IEtagCacheStorage {
    fun boot(identifier: String)

    fun getRawEtagFileName(key: String): String?
    fun storeFileAndEtag(etagHolder: EtagHolder)
    fun getStoredFile(key: String, etagValue: String): String
    fun saveOfflineStaging()
    fun removeOfflineStaging()
    fun restoreOfflineStaging()
}
