package com.usercentrics.sdk.v2.file

internal interface IFileStorage {

    companion object {
        internal const val baseDirectoryName = "usercentrics"
    }

    fun getFile(fileRelativePath: String): String?
    fun storeFile(fileRelativePath: String, fileContent: String)
    fun mkdir(relativePath: String)
    fun ls(relativePath: String): List<String>?
    fun rm(relativePath: String)
    fun rmdir(relativePath: String)
    fun copy(fromRelativePath: String, toRelativePath: String)
    fun rmAll()
}
