package com.usercentrics.sdk.v2.language.facade

import com.usercentrics.sdk.v2.language.service.ILanguageService
import com.usercentrics.sdk.v2.location.data.LocationAwareResponse

internal class LanguageFacade(
    private val languageService: ILanguageService
) : ILanguageFacade {

    override suspend fun resolveLanguage(settingsId: String, version: String, defaultLanguage: String, bypassCache: Boolean): Result<LocationAwareResponse<String>> {
        return try {
            languageService.loadSelectedLanguage(settingsId = settingsId, version = version, defaultLanguage = defaultLanguage, bypassCache = bypassCache)
            Result.success(LocationAwareResponse(
                data = languageService.selectedLanguage!!,
                location = languageService.userLocation!!,
                languageEtagChanged = languageService.languagesEtagChanged))
        } catch (ex: Exception) {
            Result.failure(ex)
        }
    }
}
