package com.usercentrics.sdk.v2.location.repository

import com.usercentrics.sdk.core.json.JsonParser
import com.usercentrics.sdk.v2.location.cache.ILocationCache
import com.usercentrics.sdk.v2.location.data.LocationData
import com.usercentrics.sdk.v2.location.data.LocationDataResponse
import com.usercentrics.sdk.v2.location.data.UsercentricsLocation

internal class LocationRepository(
    private val locationCache: ILocationCache,
    private val jsonParser: JsonParser
) : ILocationRepository {

    override fun getCachedLocation(): LocationData? {
        val cachedLocation = locationCache.getCachedLocation() ?: return null
        return parseJson(cachedLocation)
    }

    override fun getInjectedLocation(): LocationData? {
        val injectedLocation = locationCache.getInjectedLocation() ?: return null
        return parseJson(injectedLocation)
    }

    override fun storeLocation(location: UsercentricsLocation) {
        locationCache.storeLocation(jsonParser.encodeToString(LocationDataResponse(LocationData(location))))
    }

    private fun parseJson(responseBody: String): LocationData {
        return jsonParser.decodeFromString(LocationDataResponse.serializer(), responseBody).data
    }
}
