package com.usercentrics.sdk.v2.ruleset.repository

import com.usercentrics.sdk.core.application.INetworkStrategy
import com.usercentrics.sdk.core.json.JsonParser
import com.usercentrics.sdk.domain.api.http.HttpResponse
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.v2.etag.cache.EtagCacheStorage
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage
import com.usercentrics.sdk.v2.location.data.UsercentricsLocation
import com.usercentrics.sdk.v2.network.NetworkOrchestrator
import com.usercentrics.sdk.v2.ruleset.api.IRuleSetApi
import com.usercentrics.sdk.v2.ruleset.data.RuleSet

internal class RuleSetRepository(
    private val ruleSetApi: IRuleSetApi,
    private val jsonParser: JsonParser,
    logger: UsercentricsLogger,
    etagCacheStorage: IEtagCacheStorage,
    networkStrategy: INetworkStrategy
) : NetworkOrchestrator(logger, etagCacheStorage, networkStrategy), IRuleSetRepository {

    override suspend fun fetchRuleSet(id: String, bypassCache: Boolean): Pair<RuleSet, UsercentricsLocation> {
        val response = resolveHttp2(bypassCache) { ruleSetApi.getRuleSet(id, getApiHeaders()) }

        val ruleSet = parseJson(response)
        return Pair(ruleSet, response.parseLocation())
    }

    override fun etagKey(): String {
        return EtagCacheStorage.ruleSetDir
    }

    private fun parseJson(response: HttpResponse): RuleSet {
        return jsonParser.decodeFromString(response.body)
    }
}
