package com.usercentrics.sdk.v2.settings.api

import com.usercentrics.sdk.BuildKonfig
import com.usercentrics.sdk.domain.api.http.HttpRequests
import com.usercentrics.sdk.domain.api.http.HttpResponse
import com.usercentrics.sdk.services.api.NetworkResolver

internal class SettingsApi(
    private val restClient: HttpRequests,
    private val networkResolver: NetworkResolver,
) : ISettingsApi {

    override suspend fun getSettings(
        settingsId: String,
        jsonFileVersion: String,
        jsonFileLanguage: String,
        headers: Map<String, String>
    ): HttpResponse {
        val url = buildUrl(settingsId, jsonFileVersion, jsonFileLanguage)
        return restClient.getSync2(url, headers)
    }

    private fun buildUrl(
        settingsId: String,
        jsonFileVersion: String,
        jsonFileLanguage: String
    ): String {
        val baseUrl = networkResolver.cdnBaseUrl()
        return "$baseUrl/${BuildKonfig.endpoint_settingsUrlPath}/$settingsId/$jsonFileVersion/$jsonFileLanguage.json"
    }

}
