package com.usercentrics.sdk.v2.settings.data

import kotlinx.serialization.Serializable

@Serializable
data class ServiceConsentTemplate(
    override val isDeactivated: Boolean? = null,
    override val defaultConsentStatus: Boolean? = null,
    override val templateId: String,
    override val version: String,
    override val categorySlug: String? = null,
    override val description: String? = null,
    override val isHidden: Boolean,
    val subConsents: List<SubConsentTemplate> = listOf(),
    val isAutoUpdateAllowed: Boolean? = null,
    val legalBasisList: List<String>? = null,
    val disableLegalBasis: Boolean? = null,
) : ConsentTemplate
