package com.usercentrics.sdk.v2.settings.data

import kotlinx.serialization.Serializable

/**
 * This feature is known as Flexible Purposes.
 * Within the Service-Specific Scope the customer can decide which Legal Basis
 * should be applied on a Purpose level.
 * The customer decision will only come into effect for Purposes which Vendors
 * have been marked as flexible via the Global Vendor List (GVL).
 * @suppress
 */
@Serializable
data class TCF2ChangedPurposes(
    val purposes: List<Int> = listOf(),
    val legIntPurposes: List<Int> = listOf(),
    val notAllowedPurposes: List<Int> = listOf(),
)
