package com.usercentrics.sdk.v2.settings.data

import kotlinx.serialization.Serializable

@Serializable
data class TCF2Settings(
    // Required
    val firstLayerTitle: String,
    val secondLayerTitle: String,
    val tabsPurposeLabel: String,
    val tabsVendorsLabel: String,
    val labelsFeatures: String,
    val labelsIabVendors: String,
    val labelsNonIabPurposes: String,
    val labelsNonIabVendors: String,
    val labelsPurposes: String,
    val vendorFeatures: String,
    val vendorLegitimateInterestPurposes: String,
    val vendorPurpose: String,
    val vendorSpecialFeatures: String,
    val vendorSpecialPurposes: String,
    val togglesConsentToggleLabel: String,
    val togglesLegIntToggleLabel: String,
    val buttonsAcceptAllLabel: String,
    val buttonsDenyAllLabel: String,
    val buttonsSaveLabel: String,
    val linksManageSettingsLabel: String,
    val linksVendorListLinkLabel: String,
    val togglesSpecialFeaturesToggleOn: String,
    val togglesSpecialFeaturesToggleOff: String,
    val firstLayerMobileVariant: FirstLayerMobileVariant? = null,
    val firstLayerHideToggles: Boolean = false,
    val secondLayerHideToggles: Boolean = false,
    val hideLegitimateInterestToggles: Boolean = false,
    val categoriesOfDataLabel: String = "",
    val dataRetentionPeriodLabel: String = "",
    val legitimateInterestLabel: String = "",
    val version: String = "",
    val examplesLabel: String = "",
    val cmpId: Int = 5,
    val cmpVersion: Int = 3,

    // Optional
    val showDataSharedOutsideEUText: Boolean = false,
    val dataSharedOutsideEUText: String? = null,
    val vendorIdsOutsideEUList: List<Int> = listOf(),
    val firstLayerHideButtonDeny: Boolean? = true,
    val secondLayerHideButtonDeny: Boolean = true,
    val publisherCountryCode: String = "DE",
    val purposeOneTreatment: Boolean = false,
    val selectedVendorIds: List<Int> = listOf(),
    val gdprApplies: Boolean = true,
    val selectedStacks: List<Int> = listOf(),
    val scope: TCF2Scope = TCF2Scope.SERVICE,
    val disabledSpecialFeatures: List<Int> = listOf(),
    val firstLayerShowDescriptions: Boolean = false,
    val hideNonIabOnFirstLayer: Boolean = false,
    val resurfacePeriodEnded: Boolean = false,
    val resurfacePurposeChanged: Boolean = false,
    val resurfaceVendorAdded: Boolean = false,
    val firstLayerDescription: String? = null,
    val firstLayerAdditionalInfo: String? = null,
    val secondLayerDescription: String? = null,
    val appLayerNoteResurface: String? = null,
    val firstLayerNoteResurface: String? = null,
    val changedPurposes: TCF2ChangedPurposes? = null,
    val acmV2Enabled: Boolean = false,
    val selectedATPIds: List<Int> = listOf(),
    val resurfaceATPListChanged: Boolean = false,
    val atpListTitle: String = ""
) {
    val useGranularChoice: Boolean
        get() = !firstLayerHideToggles || !secondLayerHideToggles

    val isServiceSpecific: Boolean
        get() = scope == TCF2Scope.SERVICE

    internal fun isAdditionalConsentModeEnabled(): Boolean {
        return acmV2Enabled && selectedATPIds.isNotEmpty()
    }
}
