package com.usercentrics.sdk.v2.settings.data

import com.usercentrics.sdk.core.json.JsonParser
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonObject

@Serializable
data class VariantsSettings(
    val enabled: Boolean,
    @SerialName("experiments")
    val experimentsJson: String,
    val activateWith: String,
) {
    companion object {
        internal const val activateWithUC = "UC"
        internal const val activateWithThirdParty = "THIRD_PARTY"
    }

    internal fun decodeVariants(jsonParser: JsonParser): List<String>? = runCatching {
        val experimentsJsonObject = jsonParser.decodeFromString(JsonObject.serializer(), experimentsJson)
        experimentsJsonObject.entries.map { it.key }
    }.getOrNull()
}
