package com.usercentrics.sdk.v2.settings.facade

import com.usercentrics.sdk.core.settings.SettingsInitializationParameters
import com.usercentrics.sdk.v2.settings.service.ICacheBypassResolver
import com.usercentrics.sdk.errors.UsercentricsException
import com.usercentrics.sdk.models.api.ApiErrors
import com.usercentrics.sdk.models.settings.LegacyExtendedSettings
import com.usercentrics.sdk.services.settings.ISettingsMapper
import com.usercentrics.sdk.v2.settings.service.ISettingsService
import com.usercentrics.sdk.v2.translation.service.ITranslationService

internal class SettingsFacade(
    private val settingsService: ISettingsService,
    private val translationService: ITranslationService,
    private val settingsMapper: ISettingsMapper,
    private val cacheBypassResolver: ICacheBypassResolver
) : ISettingsFacade {

    override suspend fun loadSettings(settingsInitParameters: SettingsInitializationParameters): Result<LegacyExtendedSettings> {
        return try {
            settingsService.loadSettings(settingsInitParameters)

            translationService.loadTranslations(language = settingsInitParameters.jsonFileLanguage, bypassCache = cacheBypassResolver.shouldBypassCache())

            val settings = settingsService.settings!!
            val translations = translationService.translations!!

            val legacyExtendedSettings = settingsMapper.map(settings.data, settings.services, translations, settingsInitParameters.controllerId)
            Result.success(legacyExtendedSettings)
        } catch (ex: Exception) {
            Result.failure(UsercentricsException(ApiErrors.FETCH_SETTINGS, ex))
        }
    }
}
