package com.usercentrics.sdk.v2.settings.service

internal interface ICacheBypassResolver {
    fun update(languageEtagChanged: Boolean, settingsEtagChanged: Boolean)
    fun shouldBypassCache(): Boolean
}

internal class CacheBypassResolver : ICacheBypassResolver {
    private var bypassCache: Boolean = false

    override fun update(languageEtagChanged: Boolean, settingsEtagChanged: Boolean) {
        bypassCache = languageEtagChanged || settingsEtagChanged == true
    }

    override fun shouldBypassCache(): Boolean = bypassCache
}
