package com.usercentrics.sdk.v2.tcf.api

import com.usercentrics.sdk.domain.api.http.HttpRequests
import com.usercentrics.sdk.domain.api.http.HttpResponse
import com.usercentrics.sdk.services.api.NetworkResolver

internal class TCFDeclarationsApi(
    private val restClient: HttpRequests,
    private val networkResolver: NetworkResolver
) : ITCFDeclarationsApi {

    override suspend fun getDeclarations(language: String, headers: Map<String, String>): HttpResponse {
        val url = buildDeclarationsUrl(language)
        return restClient.getSync2(url, headers)
    }

    private fun buildDeclarationsUrl(language: String): String {
        val baseUrl = networkResolver.cdnBaseUrl()
        val languageSanitized = language.replace("_", "-").lowercase()
        return "${baseUrl}/gvl/v3/$languageSanitized.json"
    }

}
