package com.usercentrics.sdk.v2.tcf.api

import com.usercentrics.sdk.domain.api.http.HttpRequests
import com.usercentrics.sdk.domain.api.http.HttpResponse
import com.usercentrics.sdk.services.api.NetworkResolver

internal class TCFVendorListApi(
    private val restClient: HttpRequests,
    private val networkResolver: NetworkResolver
) : ITCFVendorListApi {

    override suspend fun getVendorList(headers: Map<String, String>): HttpResponse {
        val url = buildVendorListUrl()
        return restClient.getSync2(url, headers)
    }

    private fun buildVendorListUrl(): String {
        val baseUrl = networkResolver.cdnBaseUrl()
        return "${baseUrl}/gvl/v3/en.json"
    }

}
