package com.usercentrics.sdk.v2.tcf.repository

import com.usercentrics.sdk.core.application.INetworkStrategy
import com.usercentrics.sdk.core.json.JsonParser
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.services.tcf.Constants
import com.usercentrics.sdk.v2.etag.cache.EtagCacheStorage
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage
import com.usercentrics.sdk.v2.network.NetworkOrchestrator
import com.usercentrics.sdk.v2.tcf.api.ITCFDeclarationsApi
import com.usercentrics.tcf.core.model.gvl.Declarations

internal class TCFDeclarationsRepository(
    private val tcfDeclarationsApi: ITCFDeclarationsApi,
    private val jsonParser: JsonParser,
    logger: UsercentricsLogger,
    etagCacheStorage: IEtagCacheStorage,
    networkStrategy: INetworkStrategy
) : NetworkOrchestrator(logger, etagCacheStorage, networkStrategy), ITCFDeclarationsRepository {

    private var currentLanguage: String = Constants.FALLBACK_LANGUAGE

    override suspend fun fetchDeclarations(language: String): Declarations {
        currentLanguage = language

        val response = resolveHttpBody2 { tcfDeclarationsApi.getDeclarations(language, getApiHeaders()) }
        return parseJson(response)
    }

    override fun etagKey(): String {
        return "${EtagCacheStorage.tcfDeclarationsDir}$currentLanguage"
    }

    private fun parseJson(responseBody: String): Declarations = jsonParser.decodeFromString(responseBody)

}
