package com.usercentrics.sdk.v2.tcf.repository

import com.usercentrics.sdk.core.application.INetworkStrategy
import com.usercentrics.sdk.core.json.JsonParser
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.v2.etag.cache.EtagCacheStorage
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage
import com.usercentrics.sdk.v2.network.NetworkOrchestrator
import com.usercentrics.sdk.v2.tcf.api.ITCFVendorListApi
import com.usercentrics.tcf.core.model.gvl.VendorList

internal class TCFVendorListRepository(
    private val tcfVendorListApi: ITCFVendorListApi,
    private val jsonParser: JsonParser,
    logger: UsercentricsLogger,
    etagCacheStorage: IEtagCacheStorage,
    networkStrategy: INetworkStrategy
) : NetworkOrchestrator(logger, etagCacheStorage, networkStrategy), ITCFVendorListRepository {

    override suspend fun fetchVendorList(): VendorList {
        val response = resolveHttpBody2 { tcfVendorListApi.getVendorList(getApiHeaders()) }
        return parseJson(response)
    }

    override fun etagKey(): String {
        return EtagCacheStorage.tcfVendorListDir
    }

    private fun parseJson(responseBody: String): VendorList = jsonParser.decodeFromString(responseBody)

}
