package com.usercentrics.sdk.v2.tcf.service

import com.usercentrics.sdk.v2.tcf.repository.ITCFDeclarationsRepository
import com.usercentrics.sdk.v2.tcf.repository.ITCFVendorListRepository
import com.usercentrics.tcf.core.model.gvl.Declarations
import com.usercentrics.tcf.core.model.gvl.VendorList

internal class TCFService(
    private val vendorListRepository: ITCFVendorListRepository,
    private val declarationsRepository: ITCFDeclarationsRepository
) : ITCFService {
    override var vendorList: VendorList? = null
        private set
    override var declarations: Declarations? = null
        private set

    override suspend fun loadVendorList() {
        vendorList = vendorListRepository.fetchVendorList()
    }

    override suspend fun loadDeclarations(language: String) {
        declarations = declarationsRepository.fetchDeclarations(language)
    }
}
