package com.usercentrics.sdk.v2.translation.api

import com.usercentrics.sdk.domain.api.http.HttpRequests
import com.usercentrics.sdk.domain.api.http.HttpResponse
import com.usercentrics.sdk.services.api.NetworkResolver

internal class TranslationApi(
    private val restClient: HttpRequests,
    private val networkResolver: NetworkResolver
) : ITranslationApi {

    override suspend fun getTranslations(language: String, headers: Map<String, String>): HttpResponse {
        val url = buildUrl(language)
        return restClient.getSync2(url, headers)
    }

    private fun buildUrl(language: String): String {
        val baseUrl = networkResolver.cdnBaseUrl()
        return "$baseUrl/translations/translations-$language.json"
    }
}
