package com.usercentrics.sdk.v2.translation.service

import com.usercentrics.sdk.v2.translation.data.LegalBasisLocalization
import com.usercentrics.sdk.v2.translation.repository.ITranslationRepository

internal class TranslationService(
    private val translationRepository: ITranslationRepository
) : ITranslationService {

    override var translations: LegalBasisLocalization? = null
        private set

    override suspend fun loadTranslations(language: String, bypassCache: Boolean) {
        translations = translationRepository.fetchTranslations(language, bypassCache)
    }
}
