package com.usercentrics.tcf.core

internal enum class IABTCFKeys(val key: String) {

    CMP_SDK_ID("IABTCF_CmpSdkID"),
    CMP_SDK_VERSION("IABTCF_CmpSdkVersion"),
    POLICY_VERSION("IABTCF_PolicyVersion"),
    GDPR_APPLIES("IABTCF_gdprApplies"),
    PUBLISHER_CC("IABTCF_PublisherCC"),
    PURPOSE_ONE_TREATMENT("IABTCF_PurposeOneTreatment"),
    USE_NON_STANDARD_STACKS("IABTCF_UseNonStandardStacks"),
    TC_STRING("IABTCF_TCString"),
    VENDOR_CONSENTS("IABTCF_VendorConsents"),
    VENDOR_LEGIT_INTERESTS("IABTCF_VendorLegitimateInterests"),
    PURPOSE_CONSENTS("IABTCF_PurposeConsents"),
    PURPOSE_LEGIT_INTERESTS("IABTCF_PurposeLegitimateInterests"),
    SPECIAL_FEATURES_OPT_INS("IABTCF_SpecialFeaturesOptIns"),
    PUBLISHER_CONSENT("IABTCF_PublisherConsent"),
    PUBLISHER_LEGIT_INTERESTS("IABTCF_PublisherLegitimateInterests"),
    PUBLISHER_CUSTOM_PURPOSES_CONSENTS("IABTCF_PublisherCustomPurposesConsents"),
    PUBLISHER_CUSTOM_PURPOSES_LEGIT_INTERESTS("IABTCF_PublisherCustomPurposesLegitimateInterests"),
    ENABLE_ADVERTISER_CONSENT_MODE("IABTCF_EnableAdvertiserConsentMode"),
    ADDITIONAL_CONSENT_MODE("IABTCF_AddtlConsent");

    companion object {

        fun publisherRestrictionsKeyOf(purpose: Int): String {
            return "IABTCF_PublisherRestrictions$purpose"
        }
    }
}
